#ifndef __ETH_INF_DIAG_H
#define __ETH_INF_DIAG_H

/////////////////////////////////////////////////////////////////////////////////////
// Ethernet Interface Diagnostic Status codes
/////////////////////////////////////////////////////////////////////////////////////
//
// MessageId: TLR_DIAG_E_ETH_INTF_INVALID_STARTUP_PARAMETER
//
// MessageText:
//
//  Invalid start-up parameter.
//
#define TLR_DIAG_E_ETH_INTF_INVALID_STARTUP_PARAMETER ((TLR_RESULT)0xC05D0001L)

//
// MessageId: TLR_DIAG_I_ETH_INTF_UNKNOWN_COMMAND_RECEIVED
//
// MessageText:
//
//  Unknown command received.
//
#define TLR_DIAG_I_ETH_INTF_UNKNOWN_COMMAND_RECEIVED ((TLR_RESULT)0x405D0002L)

//
// MessageId: TLR_DIAG_E_ETH_INTF_SEND_PACKET_FAILED
//
// MessageText:
//
//  Failed to send packet.
//
#define TLR_DIAG_E_ETH_INTF_SEND_PACKET_FAILED ((TLR_RESULT)0xC05D0003L)

//
// MessageId: TLR_DIAG_E_ETH_INTF_GET_PACKET_FAILED
//
// MessageText:
//
//  Failed to get packet.
//
#define TLR_DIAG_E_ETH_INTF_GET_PACKET_FAILED ((TLR_RESULT)0xC05D0004L)

//
// MessageId: TLR_DIAG_E_ETH_INTF_PACKET_DONE_FAILED
//
// MessageText:
//
//  Failed to return or release packet.
//
#define TLR_DIAG_E_ETH_INTF_PACKET_DONE_FAILED ((TLR_RESULT)0xC05D0005L)

//
// MessageId: TLR_DIAG_E_ETH_INTF_SET_DRV_EDD_CFG
//
// MessageText:
//
//  Failed to set driver EDD configuration.
//
#define TLR_DIAG_E_ETH_INTF_SET_DRV_EDD_CFG ((TLR_RESULT)0xC05D0006L)

//
// MessageId: TLR_DIAG_E_ETH_INTF_GET_BUFFER
//
// MessageText:
//
//  Failed to get Ethernet buffer.
//
#define TLR_DIAG_E_ETH_INTF_GET_BUFFER   ((TLR_RESULT)0xC05D0007L)

//
// MessageId: TLR_DIAG_E_ETH_INTF_FREE_BUFFER
//
// MessageText:
//
//  Failed to free Ethernet buffer.
//
#define TLR_DIAG_E_ETH_INTF_FREE_BUFFER  ((TLR_RESULT)0xC05D0008L)

//
// MessageId: TLR_DIAG_E_ETH_INTF_SEND_BUFFER
//
// MessageText:
//
//  Failed to send Ethernet buffer.
//
#define TLR_DIAG_E_ETH_INTF_SEND_BUFFER  ((TLR_RESULT)0xC05D0009L)

//
// MessageId: TLR_DIAG_E_ETH_INTF_GET_DRV_EDD_DIAG
//
// MessageText:
//
//  Failed to get diagnostic information from driver EDD.
//
#define TLR_DIAG_E_ETH_INTF_GET_DRV_EDD_DIAG ((TLR_RESULT)0xC05D000AL)

//
// MessageId: TLR_DIAG_E_ETH_INTF_INVALID_ETH_PORT
//
// MessageText:
//
//  Invalid parameter for ethernet port.
//
#define TLR_DIAG_E_ETH_INTF_INVALID_ETH_PORT ((TLR_RESULT)0xC05D000BL)




#endif  //__ETH_INF_DIAG_H

